const GroupServiceUtil = Packages.com.liferay.portal.service.GroupServiceUtil();
const PortletBeanLocatorUtil = Packages.com.liferay.portal.kernel.bean.PortletBeanLocatorUtil();
const UserLocalServiceUtil = Packages.com.liferay.portal.service.UserLocalServiceUtil();
const LayoutServiceUtil = Packages.com.liferay.portal.service.LayoutServiceUtil();
const LayoutLocalServiceUtil = Packages.com.liferay.portal.service.LayoutLocalServiceUtil();
const PortletPreferencesLocalServiceUtil = com.liferay.portal.service.PortletPreferencesLocalServiceUtil();
const PortalUtil = Packages.com.liferay.portal.util.PortalUtil();
const GroupConstants = Packages.com.liferay.portal.model.GroupConstants();
const LayoutConstants = Packages.com.liferay.portal.model.LayoutConstants();
const PortletKeys = Packages.com.liferay.portal.util.PortletKeys();
const DLAppServiceUtil = Packages.com.liferay.portlet.documentlibrary.service.DLAppServiceUtil();
const DLFileEntryLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil();
const DLFolderLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil();
const JournalArticleLocalServiceUtil = com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil();

const defaultCompanyId = PortalUtil.getDefaultCompanyId();
const adminUser = UserLocalServiceUtil.getUserByScreenName(defaultCompanyId, "padmin");
const serviceContext = Packages.com.liferay.portal.service.ServiceContext();
const defaultParentLayoutId = LayoutConstants.DEFAULT_PARENT_LAYOUT_ID;
const ownerId = PortletKeys.PREFS_OWNER_ID_DEFAULT;
const ownerType = PortletKeys.PREFS_OWNER_TYPE_LAYOUT;

const stagingGroupId = 381376;

var layouts = LayoutLocalServiceUtil.getLayouts(stagingGroupId, true).toArray(); 
var furls = [];

for (var l in layouts) {
  var layout = layouts[l];
  var layoutTypePortlet = layout.getLayoutType();
  var portletIds = layoutTypePortlet.getPortletIds().toArray();
  
for (var p in portletIds) {
  var portletId = portletIds[p];
  var portletPrefs = PortletPreferencesLocalServiceUtil.getPreferences(layout.getCompanyId(), ownerId, ownerType, layout.getPlid(), portletId );
  
  var mykeys = portletPrefs.getMap().keySet().toArray();
  var showPrefs = false;
  
  for (var n in mykeys) {
    var key = mykeys[n];
    if (key == "portlet-pref-articleFurl") {
      furls.push(portletPrefs.getValue(key, ""));
    }
  }
}
}

out.println(furls.length);

//for (var f in furls) {
//  out.println(furls[f]);
//}

var articles = JournalArticleLocalServiceUtil.getArticles(stagingGroupId).toArray();
for (var a in articles) {
  var article = articles[a];
  var furl = article.getUrlTitle();
  
  if (furl.startsWith("-library")) {
    if (isInUse(furl)) {
      out.println("FURL " + furl + " " + article.getLayoutUuid());
    }
    else if (!article.getLayoutUuid().isEmpty()) {
      out.println("Display Page " + furl + " " + article.getLayoutUuid());
    }
    else {
      out.println("Deleting " + furl + " " + article.getLayoutUuid());
      serviceContext.setUserId(article.getUserId());
      serviceContext.setScopeGroupId(article.getGroupId());

      //JournalArticleLocalServiceUtil.deleteArticle(article.getGroupId(), article.getArticleId(), serviceContext);
    }

  }
}

function isInUse(furl) {
  for (var f in furls) {
    if (furls[f] == furl) {
      return true;
    }
  }
  return false;
}